package com.agilex.healthcare.veteranappointment.datalayer.patient;

import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.veteranappointment.domain.VARPatientPreference;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

@Service
public class PatientPreferenceDataLayerRepo implements PatientPreferenceDataLayer {

	@Resource
    NotificationPreferenceDao notificationPreferenceDao;

	public VARPatientPreference fetchPatientPreference(PatientIdentifier patientId ){
		NotificationPreferencePo notificationPreference = notificationPreferenceDao.get(patientId.getUniqueId());
        VARPatientPreference preference = notificationPreference.create();
		preference.setPatientIdentifier(patientId);
		return preference;
	}
	
	public VARPatientPreference updatePatientPreference(VARPatientPreference patientPreference){
		NotificationPreferencePo notificationPreference = notificationPreferenceDao.update(patientPreference);
        VARPatientPreference preference = notificationPreference.create();
		preference.setPatientIdentifier(patientPreference.getPatientIdentifier());
		return preference;
	}
	
	public void deletePatientPreference(VARPatientPreference patientPreference){
		notificationPreferenceDao.delete(patientPreference);
	}
	

}
